
import gurobi

def solve_keyboard_factory_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    R = model.addVar(lb=0, ub=300, name="Regular_Keyboard")
    M = model.addVar(lb=0, ub=150, name="Mechanical_Keyboard")

    # Objective function: Maximize profit
    model.setObjective(30*R + 60*M, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(R >= 165, name="Regular_Demand")
    model.addConstr(M >= 70, name="Mechanical_Demand")
    model.addConstr(R <= 300, name="Regular_Capacity")
    model.addConstr(M <= 150, name="Mechanical_Capacity")
    model.addConstr(R + M >= 250, name="Contract_Requirement")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Regular Keyboards: {R.varValue}")
        print(f"Mechanical Keyboards: {M.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_keyboard_factory_problem()
