
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("fish_mixture")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x") # Bags of A
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="y") # Bags of B

# Set objective function
model.setObjective(4*x + 6*y, GRB.MINIMIZE)

# Add constraints
model.addConstr(2*x + 4*y >= 20, "sardines")
model.addConstr(3*x + y >= 25, "anchovies")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Bags of A: {x.x:.2f}")
    print(f"Bags of B: {y.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

