
from gurobipy import *

# Create a new model
m = Model("Aquarium_Feeding")

# Define variables
x_A = m.addVar(name="Bag_A", vtype=GRB.CONTINUOUS, lb=0)
x_B = m.addVar(name="Bag_B", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function to minimize cost
m.setObjective(4*x_A + 6*x_B, GRB.MINIMIZE)

# Add constraints for sardines and anchovies
m.addConstr(2*x_A + 4*x_B >= 20, name="Sardine_Requirement")
m.addConstr(3*x_A + x_B >= 25, name="Anchovy_Requirement")

# Optimize the model
m.optimize()

# Check if an optimal solution was found
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Bag A: {x_A.x}")
    print(f"Number of Bag B: {x_B.x}")
    print(f"Total Cost: ${m.objVal}")
else:
    print("No optimal solution found")
