
import gurobi

def solve_aquarium_feeding_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, name="x")  # Number of bags of type A
    y = model.addVar(lb=0, name="y")  # Number of bags of type B

    # Define the objective function
    model.setObjective(4*x + 6*y, gurobi.GRB.MINIMIZE)

    # Add the sardine constraint
    model.addConstr(2*x + 4*y >= 20, name="sardine_constraint")

    # Add the anchovy constraint
    model.addConstr(3*x + y >= 25, name="anchovy_constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"x (Bags of A): {x.varValue}")
        print(f"y (Bags of B): {y.varValue}")
        print(f"Minimum Cost: ${model.objVal:.2f}")
    else:
        print("The model is infeasible or unbounded.")

solve_aquarium_feeding_problem()
