
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
x1 = m.addVar(lb=0, name="x1") # Days to operate farm 1
x2 = m.addVar(lb=0, name="x2") # Days to operate farm 2


# Set objective function
m.setObjective(500*x1 + 400*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x1 + 7*x2 >= 50, "apple_constraint")
m.addConstr(15*x1 + 8*x2 >= 60, "orange_constraint")
m.addConstr(5*x1 + 9*x2 >= 55, "pear_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal}")
    print(f"Days to operate farm 1: {x1.x}")
    print(f"Days to operate farm 2: {x2.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

