
from gurobipy import *

# Create a new model
m = Model("Fruit_Farm_Optimization")

# Define the decision variables
x1 = m.addVar(lb=0, name="farm1_days")
x2 = m.addVar(lb=0, name="farm2_days")

# Set the objective function
m.setObjective(500*x1 + 400*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x1 + 7*x2 >= 50, name="apple_constraint")
m.addConstr(15*x1 + 8*x2 >= 60, name="orange_constraint")
m.addConstr(5*x1 + 9*x2 >= 55, name="pear_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Farm 1 operates for {x1.x} days")
    print(f"Farm 2 operates for {x2.x} days")
    print(f"Total cost: ${m.objVal}")
else:
    print("No optimal solution found")

