
import gurobipy as gp

# Create a new model
m = gp.Model("FruitFarmer")

# Define the decision variables
x1 = m.addVar(name="x1", lb=0)  # number of days to operate farm 1
x2 = m.addVar(name="x2", lb=0)  # number of days to operate farm 2

# Define the objective function
m.setObjective(500 * x1 + 400 * x2, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(10 * x1 + 7 * x2 >= 50, name="apples")
m.addConstr(15 * x1 + 8 * x2 >= 60, name="oranges")
m.addConstr(5 * x1 + 9 * x2 >= 55, name="pears")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Operate farm 1 for {x1.varValue} days.")
    print(f"Operate farm 2 for {x2.varValue} days.")
    print(f"Total cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")
