
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("kayak_canoe")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kayaks")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="canoes")

# Set objective
m.setObjective(300 * x + 450 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(60 * x + 80 * y <= 8000, "assembly")
m.addConstr(15 * x + 25 * y <= 4000, "quality_check")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of kayaks: {x.x}")
    print(f"Number of canoes: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

