
from gurobipy import *

# Create a model
m = Model("Kayak_Canoe_Profit_Optimization")

# Define the decision variables
k = m.addVar(name="kayaks", lb=0)  # Number of kayaks
c = m.addVar(name="canoes", lb=0)  # Number of canoes

# Objective function: Maximize profit
m.setObjective(300*k + 450*c, GRB.MAXIMIZE)

# Assembly time constraint
m.addConstr(60*k + 80*c <= 8000, name="assembly_time")

# Quality checking time constraint
m.addConstr(15*k + 25*c <= 4000, name="quality_checking_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of kayaks: {k.x}")
    print(f"Number of canoes: {c.x}")
    print(f"Maximum profit: ${300*k.x + 450*c.x:.2f}")
else:
    print("No optimal solution found")
