
import gurobi as gp

# Create a new model
m = gp.Model("Kayak_Canoe_Production")

# Define variables
K = m.addVar(name="Kayaks", lb=0, vtype=gp.GRB.CONTINUOUS)  # Number of kayaks
C = m.addVar(name="Canoes", lb=0, vtype=gp.GRB.CONTINUOUS)  # Number of canoes

# Objective function: Maximize profit
m.setObjective(300*K + 450*C, gp.GRB.MAXIMIZE)

# Assembly time constraint
m.addConstr(60*K + 80*C <= 8000, name="Assembly_Time")

# Quality checking time constraint
m.addConstr(15*K + 25*C <= 4000, name="Quality_Checking_Time")

# Solve the model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Production levels: Kayaks = {K.varValue}, Canoes = {C.varValue}")
    print(f"Maximum profit: ${300*K.varValue + 450*C.varValue:.2f}")
else:
    print("No optimal solution found.")
