
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("microphone_optimization")

# Create decision variables
x = m.addVar(vtype=GRB.INTEGER, name="regular_mics")
y = m.addVar(vtype=GRB.INTEGER, name="premium_mics")

# Set objective function
m.setObjective(80*x + 95*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(75*x + 100*y <= 30000, "budget_constraint")
m.addConstr(x + y <= 300, "demand_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of regular microphones: {x.x}")
    print(f"Number of premium microphones: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {m.status}")

