
from gurobipy import *

# Create a new model
m = Model("Microphone_Profit")

# Define variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="regular_microphones")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="premium_microphones")

# Set the objective function
m.setObjective(5*x - 5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(75*x + 100*y <= 30000, "budget_constraint")
m.addConstr(x + y <= 300, "demand_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.x}, y = {y.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("Model is infeasible")
