
import gurobi

def solve_microphone_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    R = model.addVar(lb=0, name="Regular_Microphones")
    P = model.addVar(lb=0, name="Premium_Microphones")

    # Objective function: Maximize profit
    model.setObjective(80*R + 95*P, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(75*R + 100*P <= 30000, name="Budget_Constraint")

    # Demand constraint
    model.addConstr(R + P <= 300, name="Demand_Constraint")

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Stock {R.varValue} regular microphones and {P.varValue} premium microphones.")
        print(f"Maximum profit: ${80*R.varValue + 95*P.varValue}")
    else:
        print("No optimal solution found.")

# Run the function
solve_microphone_problem()
