
import gurobipy as gp

# Create a new model
model = gp.Model("Washing_Dryer_Installation")

# Create decision variables
w = model.addVar(vtype=gp.GRB.CONTINUOUS, name="washing_machines") # Allowing fractional installations for simplicity.  Change to INTEGER if only whole number installations are allowed.
d = model.addVar(vtype=gp.GRB.CONTINUOUS, name="dryers") # Allowing fractional installations for simplicity. Change to INTEGER if only whole number installations are allowed.


# Set objective function
model.setObjective(200*w + 150*d, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*w + 10*d <= 2000, "plumber_time")
model.addConstr(15*w + 25*d <= 3000, "electrician_time")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of washing machines to install: {w.x}")
    print(f"Number of dryers to install: {d.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

