
from gurobipy import *

# Create a new model
m = Model("Installation_Optimization")

# Define the decision variables
W = m.addVar(vtype=GRB.INTEGER, name="Washing_Machines")
D = m.addVar(vtype=GRB.INTEGER, name="Dryers")

# Objective function: Maximize profit
m.setObjective(200*W + 150*D, GRB.MAXIMIZE)

# Constraints
m.addConstr(20*W + 10*D <= 2000, "Plumber_Time")
m.addConstr(15*W + 25*D <= 3000, "Electrician_Time")

# Non-negativity constraints (automatically handled by addVar for integer types)

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Install {W.x} washing machines")
    print(f"Install {D.x} dryers")
    print(f"Total Profit: ${200*W.x + 150*D.x}")
else:
    print("No optimal solution found")
