
import gurobi

def solve_installation_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    W = model.addVar(name="Washing_Machines", vtype=gurobi.GRB.INTEGER, lb=0)
    D = model.addVar(name="Dryers", vtype=gurobi.GRB.INTEGER, lb=0)

    # Objective: Maximize 200W + 150D
    model.setObjective(200 * W + 150 * D, sense=gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(20 * W + 10 * D <= 2000, name="Plumber_Time")
    model.addConstr(15 * W + 25 * D <= 3000, name="Electrician_Time")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal washing machines to install: {W.varValue}")
        print(f"Optimal dryers to install: {D.varValue}")
        print(f"Max Profit: ${model.objVal}")
    else:
        print("No optimal solution found")

if __name__ == "__main__":
    solve_installation_problem()
