
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("advertising_optimization")

# Decision variables: Number of ads on each platform
banana = m.addVar(vtype=GRB.INTEGER, name="banana")
durian = m.addVar(vtype=GRB.INTEGER, name="durian")
orange = m.addVar(vtype=GRB.INTEGER, name="orange")

# Objective function: Maximize total viewers
m.setObjective(300000 * banana + 10000 * durian + 12000 * orange, GRB.MAXIMIZE)

# Constraints
m.addConstr(1500 * banana + 300 * durian + 500 * orange <= 20000, "budget")  # Budget constraint
m.addConstr(durian <= 15, "durian_limit")  # Durian TV ad limit
m.addConstr(orange <= (banana + durian + orange) / 3, "orange_proportion")  # Orange Premium Video proportion
m.addConstr(banana >= 0.05 * (banana + durian + orange), "banana_proportion")  # Banana Livestream proportion

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Banana Livestream ads: {banana.x}")
    print(f"Number of Durian TV ads: {durian.x}")
    print(f"Number of Orange Premium Video ads: {orange.x}")
    print(f"Total Viewers: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status {m.status}")

