
from gurobipy import *

# Create a model
m = Model("Advertising_Optimization")

# Define the decision variables
B = m.addVar(vtype=GRB.INTEGER, name="Banana_Livestream")
D = m.addVar(vtype=GRB.INTEGER, name="Durian_TV")
O = m.addVar(vtype=GRB.INTEGER, name="Orange_Premium_Video")

# Define the objective function
m.setObjective(300000*B + 10000*D + 12000*O, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1500*B + 300*D + 500*O <= 20000, "Budget_Constraint")
m.addConstr(D <= 15, "Durian_TV_Limit")
m.addConstr(O <= (1/3)*(B + D + O), "Orange_Balance")
m.addConstr(B >= 0.05*(B + D + O), "Banana_Minimum")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Banana Livestream:", B.x)
    print("Durian TV:", D.x)
    print("Orange Premium Video:", O.x)
else:
    print("No optimal solution found")
