
import gurobipy as gp

# Create a new model
m = gp.Model("Advertising_Optimization")

# Decision variables
B = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="Banana_Livestream")
D = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="Durian_TV")
O = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="Orange_Premium_Video")

# Objective function: Maximize total audience
m.setObjective(300000*B + 10000*D + 12000*O, gp.GRB.MAXIMIZE)

# Budget constraint
m.addConstr(1500*B + 300*D + 500*O <= 20000, name="Budget_Constraint")

# Durian TV ad limit
m.addConstr(D <= 15, name="Durian_TV_Limit")

# Orange Premium Video limit (at most a third of total ads)
m.addConstr(O <= (B + D + O)/3, name="Orange_Premium_Video_Limit")

# Banana Livestream minimum (at least 5% of total ads)
m.addConstr(B >= 0.05*(B + D + O), name="Banana_Livestream_Minimum")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Banana Livestream: {B.varValue}")
    print(f"Durian TV: {D.varValue}")
    print(f"Orange Premium Video: {O.varValue}")
    print(f"Total Audience: {300000*B.varValue + 10000*D.varValue + 12000*O.varValue}")
else:
    print("The model is infeasible.")
