
import gurobipy as gp

# Create a new model
m = gp.Model("SupplementOptimization")

# Create decision variables
r = m.addVar(lb=0, name="regular")
p = m.addVar(lb=0, name="premium")

# Set objective function
m.setObjective(0.04 * r + 0.08 * p, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(0.20 * r + 0.25 * p >= 30, "IronRequirement")
m.addConstr(0.30 * r + 0.40 * p >= 50, "CalciumRequirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Regular supplement: {r.x} grams")
    print(f"Premium supplement: {p.x} grams")
    print(f"Minimum cost: ${m.objVal:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

