
from gurobipy import *

# Create a model
m = Model("David_Supplementation")

# Define variables
x = m.addVar(lb=0, name="Regular_Supplementation")  # Amount of regular supplementation in grams
y = m.addVar(lb=0, name="Premium_Supplementation")  # Amount of premium supplementation in grams

# Objective function: Minimize total cost
m.setObjective(0.04*x + 0.08*y, GRB.MINIMIZE)

# Constraints
m.addConstr(0.20*x + 0.25*y >= 30, name="Iron_Requirement")
m.addConstr(0.30*x + 0.40*y >= 50, name="Calcium_Requirement")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular supplementation: {x.x} grams")
    print(f"Premium supplementation: {y.x} grams")
    print(f"Total cost: ${0.04*x.x + 0.08*y.x}")
else:
    print("No optimal solution found")

