
import gurobi

def solve_supplementation_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    R = model.addVar(lb=0, name="Regular_Supplementation")
    P = model.addVar(lb=0, name="Premium_Supplementation")

    # Define the objective function
    model.setObjective(0.04 * R + 0.08 * P, gurobi.GRB.MINIMIZE)

    # Add the iron requirement constraint
    model.addConstr(0.20 * R + 0.25 * P >= 30, name="Iron_Requirement")

    # Add the calcium requirement constraint
    model.addConstr(0.30 * R + 0.40 * P >= 50, name="Calcium_Requirement")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Regular Supplementation: {R.varValue} grams")
        print(f"Premium Supplementation: {P.varValue} grams")
        print(f"Total Cost: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_supplementation_problem()
