
import gurobipy as gp

# Create a new model
model = gp.Model("Sid's Diet")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hamburgers")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pasta")

# Set objective function
model.setObjective(3*x + 4*y, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(x >= 2, "meat")
model.addConstr(0.5*x + y >= 1, "dairy")
model.addConstr(x + y >= 4, "vegetables")
model.addConstr(x + 2*y >= 3, "grains")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal}")
    print(f"Number of hamburgers: {x.x}")
    print(f"Number of pasta plates: {y.x}")
else:
    print("No solution found.")

