
from gurobipy import *

# Create a new model
m = Model("Sid's Dietary Problem")

# Define the variables
x1 = m.addVar(name='hamburgers', vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name='pasta', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(3*x1 + 4*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 >= 2, name='meat_requirement')
m.addConstr(0.5*x1 + x2 >= 1, name='dairy_requirement')
m.addConstr(x1 + x2 >= 4, name='vegetables_requirement')
m.addConstr(x1 + 2*x2 >= 3, name='grains_requirement')

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Objective Function Value: {m.objVal}")
