
import gurobi

def solve_integer_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables as integers
    x1 = model.addVar(lb=0, type=gurobi.GRB.INTEGER, name="hamburgers")
    x2 = model.addVar(lb=0, type=gurobi.GRB.INTEGER, name="plates_of_pasta")

    # Objective: Minimize cost
    model.setObjective(3*x1 + 4*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 >= 2, name="meat_requirement")
    model.addConstr(0.5*x1 + x2 >= 1, name="dairy_requirement")
    model.addConstr(x1 + x2 >= 4, name="vegetables_requirement")
    model.addConstr(x1 + 2*x2 >= 3, name="grains_requirement")

    # Optimize
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal cost: {model.objVal}")
        print(f"Hamburgers: {x1.varValue}")
        print(f"Plates of pasta: {x2.varValue}")
    else:
        print("No optimal integer solution found")

solve_integer_optimization_problem()
