
import gurobipy as gp

# Create a new model
model = gp.Model("MeatFactory")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="burgers")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hotdogs")

# Set objective function
model.setObjective(0.3 * x + 0.2 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * x + 2 * y <= 2000, "meat_constraint")
model.addConstr(2 * x + y <= 1800, "binding_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Revenue: ${model.objVal:.2f}")
    print(f"Number of Burgers: {x.x}")
    print(f"Number of Hot Dogs: {y.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

