
from gurobipy import *

# Create a new model
m = Model("Meat_Factory_Optimization")

# Define the decision variables
B = m.addVar(vtype=GRB.CONTINUOUS, name="burgers")
H = m.addVar(vtype=GRB.CONTINUOUS, name="hot_dogs")

# Set the objective function
m.setObjective(0.30*B + 0.20*H, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*B + 2*H <= 2000, "meat_constraint")
m.addConstr(2*B + H <= 1800, "binding_agent_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Burgers: {B.x}")
    print(f"Hot-dogs: {H.x}")
    print(f"Max Revenue: {m.objVal}")
else:
    print("No optimal solution found")

