
import gurobi as gp

# Create a new model
model = gp.Model("Burgers_and_Hotdogs")

# Define variables
B = model.addVar(lb=0, name="Burgers")
H = model.addVar(lb=0, name="Hotdogs")

# Objective function: Maximize revenue
model.setObjective(0.30*B + 0.20*H, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(3*B + 2*H <= 2000, name="Meat_Constraint")
model.addConstr(2*B + H <= 1800, name="Binding_Agent_Constraint")

# Optimize
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal number of burgers: {B.varValue}")
    print(f"Optimal number of hot-dogs: {H.varValue}")
    print(f"Max Revenue: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
