
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("tech_company_profit")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="phones")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="laptops")

# Set objective function
m.setObjective(300*x + 500*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x + 4*y <= 200, "silicon_chips")
m.addConstr(5*x + 6*y <= 250, "engineering_time")
m.addConstr(3*x + y <= 300, "assembly_time")
m.addConstr(x >= 30, "min_phones")
m.addConstr(y >= 30, "min_laptops")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${m.objVal}")
    print(f"Number of Phones: {x.x}")
    print(f"Number of Laptops: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

