
from gurobipy import *

# Create a new model
m = Model("TechCompanyProfit")

# Define variables
x_p = m.addVar(lb=30, vtype=GRB.CONTINUOUS, name="phones_produced")
x_l = m.addVar(lb=30, vtype=GRB.CONTINUOUS, name="laptops_produced")

# Objective function: Maximize profit
m.setObjective(300*x_p + 500*x_l, GRB.MAXIMIZE)

# Constraints
m.addConstr(2*x_p + 4*x_l <= 200, "silicon_chip_availability")
m.addConstr(5*x_p + 6*x_l <= 250, "engineering_time")
m.addConstr(3*x_p + x_l <= 300, "assembly_time")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Phones produced: {x_p.x}")
    print(f"Laptops produced: {x_l.x}")
    print(f"Maximum profit: ${300*x_p.x + 500*x_l.x:.2f}")
else:
    print("No optimal solution found")
