
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    P = model.addVar(lb=30, name="P")  # Number of phones
    L = model.addVar(lb=30, name="L")  # Number of laptops

    # Objective function: Maximize profit
    model.setObjective(300 * P + 500 * L, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2 * P + 4 * L <= 200, name="silicon_chips")
    model.addConstr(5 * P + 6 * L <= 250, name="engineering_time")
    model.addConstr(3 * P + L <= 300, name="assembly_time")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal profit: ${model.objVal}")
        print(f"Phones produced: {P.varValue}")
        print(f"Laptops produced: {L.varValue}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
