
import gurobipy as gp

# Create a new model
m = gp.Model("Investment Optimization")

# Create decision variables
x = m.addVar(name="mining_investment", lb=0)  # Mining investment
y = m.addVar(name="logging_investment", lb=0)  # Logging investment

# Set objective function: Maximize total return
m.setObjective(0.09 * x + 0.05 * y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 100000, "total_investment")
m.addConstr(x >= 0.30 * 100000, "min_mining")
m.addConstr(y <= 0.55 * 100000, "max_logging")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in mining: ${x.x:.2f}")
    print(f"Optimal investment in logging: ${y.x:.2f}")
    print(f"Maximum return: ${m.objVal:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

