
from gurobipy import *

# Create a model
m = Model("Investment_Optimization")

# Define decision variables
M = m.addVar(name="Mining_Investment", lb=30000)  # Minimum investment in mining is $30,000
L = m.addVar(name="Logging_Investment", ub=55000)  # Maximum investment in logging is $55,000

# Objective function: Maximize return on investment
m.setObjective(0.09*M + 0.05*L, GRB.MAXIMIZE)

# Constraint: Total investment should not exceed $100,000
m.addConstr(M + L <= 100000, name="Total_Investment")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Invest ${M.x:.2f} in mining")
    print(f"Invest ${L.x:.2f} in logging")
    print(f"Total return: ${0.09*M.x + 0.05*L.x:.2f}")
else:
    print("No optimal solution found")

