
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x = model.addVar(name="mining_investment", lb=0)
    y = model.addVar(name="logging_investment", lb=0)

    # Objective function: Maximize 0.09x + 0.05y
    model.setObjective(0.09 * x + 0.05 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y == 100000, name="total_investment")
    model.addConstr(x >= 0.30 * 100000, name="min_mining_investment")
    model.addConstr(y <= 0.55 * 100000, name="max_logging_investment")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in mining: ${x.varValue:.2f}")
        print(f"Optimal investment in logging: ${y.varValue:.2f}")
        print(f"Max return: ${0.09 * x.varValue + 0.05 * y.varValue:.2f}")
    else:
        print("The model is infeasible.")

solve_investment_problem()
