
from gurobipy import *

# Create a model
m = Model("Ad_Optimization")

# Decision variables
x_m = m.addVar(vtype=GRB.INTEGER, name="Mall_ads")
x_b = m.addVar(vtype=GRB.INTEGER, name="Bus_stop_ads", ub=20)
x_t = m.addVar(vtype=GRB.INTEGER, name="Theatre_ads")

# Objective function: Maximize viewership
m.setObjective(50000*x_m + 10000*x_b + 20000*x_t, GRB.MAXIMIZE)

# Constraints
m.addConstr(5000*x_m + 1000*x_b + 3000*x_t <= 30000, name="Budget")
m.addConstr(x_b <= 20, name="Bus_stop_limit")
m.addConstr(2*x_t <= x_m + x_b, name="Theatre_max_proportion")
m.addConstr(4*x_m >= x_b + x_t, name="Mall_min_proportion")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Mall ads: {x_m.x}")
    print(f"Bus stop ads: {x_b.x}")
    print(f"Theatre ads: {x_t.x}")
else:
    print("No optimal solution found.")
