
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Movie_Advertisement")

# Variables
M = model.addVar(name="Malls", vtype=GRB.INTEGER)  # Ads in malls
B = model.addVar(name="Bus_Stops", vtype=GRB.INTEGER)  # Ads at bus stops
T = model.addVar(name="Theatres", vtype=GRB.INTEGER)  # Ads in theatres

# Objective: Maximize viewership
model.setObjective(50000*M + 10000*B + 20000*T, GRB.MAXIMIZE)

# Budget constraint
model.addConstr(5000*M + 1000*B + 3000*T <= 30000, name="Budget")

# Bus stop ad limit
model.addConstr(B <= 20, name="Bus_Stop_Limit")

# Theatre ad limit: at most a third of total ads
model.addConstr(T <= (M + B + T) / 3, name="Theatre_Limit")

# Mall ad minimum: at least 20% of total ads
model.addConstr(M >= 0.20 * (M + B + T), name="Mall_Minimum")

# Non-negativity is inherently handled by adding as integer variables

# Solve the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Ads in Malls: {M.varValue}")
    print(f"Ads at Bus Stops: {B.varValue}")
    print(f"Ads in Theatres: {T.varValue}")
    print(f"Max Viewership: {model.objVal}")
else:
    print("The model is infeasible")
