
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("fruit_stand")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="lemons") # Allowing fractional lemons and bananas for simplicity.  Could be changed to GRB.INTEGER
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bananas")

# Set objective
m.setObjective(2*x + y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x + 1.5*y <= 1000, "budget")
m.addConstr(x >= 250, "min_lemons")
m.addConstr(x <= 300, "max_lemons")
m.addConstr(y <= (1/3)*x, "max_bananas")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Lemons: %g' % x.x)
    print('Bananas: %g' % y.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

