
from gurobipy import *

# Create a model
m = Model("Food_Store_Optimization")

# Define variables
L = m.addVar(vtype=GRB.INTEGER, name="lemons")
B = m.addVar(vtype=GRB.INTEGER, name="bananas")

# Objective function: Maximize profit
m.setObjective(2*L + B, GRB.MAXIMIZE)

# Constraints
m.addConstr(3*L + 1.5*B <= 1000, "budget_constraint")
m.addConstr(L >= 250, "min_lemons_sold")
m.addConstr(L <= 300, "max_lemons_sold")
m.addConstr(B <= (1/3)*L, "bananas_vs_lemons")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Lemons to sell: {L.x}")
    print(f"Bananas to sell: {B.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
