
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    L = model.addVar(lb=250, ub=300, name="Lemons")  # At least 250, at most 300 lemons
    B = model.addVar(name="Bananas")  # No explicit bounds for bananas

    # Objective function: Maximize profit
    model.setObjective(2*L + B, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(3*L + 1.5*B <= 1000, name="Budget_Constraint")

    # Banana sales constraint
    model.addConstr(B <= L/3, name="Banana_Sales_Constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Lemons = {L.varValue}, Bananas = {B.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
