
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("baseball_game")

    # Create variables
    x = m.addVar(vtype=gp.GRB.INTEGER, name="slow_balls")
    y = m.addVar(vtype=gp.GRB.INTEGER, name="fast_balls")

    # Set objective
    m.setObjective(3*x + 5*y, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x >= 5, "min_slow")
    m.addConstr(y >= 3, "min_fast")
    m.addConstr(x <= 8, "max_slow")
    m.addConstr(y <= 8, "max_fast")
    m.addConstr(x + y <= 12, "total_balls")

    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal score: {m.objVal}")
        print(f"Slow balls: {x.x}")
        print(f"Fast balls: {y.x}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
