
from gurobipy import *

# Create a new model
m = Model("Ball_Hitting_Optimization")

# Define the decision variables
x_s = m.addVar(name='slow_balls', vtype=GRB.INTEGER, lb=5, ub=8)
x_f = m.addVar(name='fast_balls', vtype=GRB.INTEGER, lb=3, ub=8)

# Set the objective function to maximize
m.setObjective(3*x_s + 5*x_f, GRB.MAXIMIZE)

# Add constraints if necessary (Gurobi handles bounds directly)
# Since we've already set lower and upper bounds on our variables,
# the only constraint left to explicitly add is the total number of balls:
m.addConstr(x_s + x_f <= 12, name='total_balls')

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Hit {x_s.x} slow balls and {x_f.x} fast balls.")
    print(f"Total points earned: {3*x_s.x + 5*x_f.x}")
else:
    print("No optimal solution found")
