
import gurobi as grb

def solve_ball_hitting_problem():
    # Create a new model
    model = grb.Model()

    # Define the variables
    S = model.addVar(lb=5, ub=8, vtype=grb.GRB.INTEGER, name="Slow_Balls")
    F = model.addVar(lb=3, ub=8, vtype=grb.GRB.INTEGER, name="Fast_Balls")

    # Set the objective function
    model.setObjective(3 * S + 5 * F, grb.GRB.MAXIMIZE)

    # Add the total balls constraint
    model.addConstr(S + F <= 12, name="Total_Balls")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == grb.GRB.OPTIMAL:
        print(f"Optimal solution: Slow Balls = {S.X}, Fast Balls = {F.X}")
        print(f"Max Points: {3 * S.X + 5 * F.X}")
    else:
        print("The model is infeasible")

solve_ball_hitting_problem()
