
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Electronics_Production")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="DVD_Players")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Projectors")

# Set objective function
model.setObjective(250*x + 200*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x + 3*y <= 250, "Silicon_Chips")
model.addConstr(6*x + 5*y <= 200, "Engineering_Time")
model.addConstr(2.5*x + 2*y <= 240, "Assembly_Time")
model.addConstr(x >= 30, "Min_DVD")
model.addConstr(y >= 30, "Min_Projectors")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${model.objVal}")
    print(f"DVD Players: {x.x}")
    print(f"Projectors: {y.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

