
from gurobipy import *

# Create a model
m = Model("Electronics_Factory")

# Decision variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="DVD_players", lb=30)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="projectors", lb=30)

# Objective function: Maximize profit
m.setObjective(250*x1 + 200*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(5*x1 + 3*x2 <= 250, "silicon_chips")
m.addConstr(6*x1 + 5*x2 <= 200, "engineering_time")
m.addConstr(2.5*x1 + 2*x2 <= 240, "assembly_time")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Produce {x1.x} DVD players and {x2.x} projectors")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found")
