
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=30, name="DVD_players")  # At least 30 DVD players
    y = model.addVar(lb=30, name="projectors")  # At least 30 projectors

    # Objective function: Maximize profit
    model.setObjective(250 * x + 200 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5 * x + 3 * y <= 250, name="silicon_chips")
    model.addConstr(6 * x + 5 * y <= 200, name="engineering_time")
    model.addConstr(2.5 * x + 2 * y <= 240, name="assembly_time")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"DVD Players: {x.varValue}")
        print(f"Projectors: {y.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
