
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("lipstick_production")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cream_lipsticks")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="matte_lipsticks")

# Set objective function
m.setObjective(70*x + 100*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3.5*x + 5*y <= 300, "raw_materials")
m.addConstr(5*x + 3*y <= 400, "mixing")
m.addConstr(2*x + 1.5*y <= 200, "packing")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Produce {x.x} cream lipsticks")
    print(f"Produce {y.x} matte lipsticks")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

