
from gurobipy import *

# Create a new model
model = Model("Lipstick_Production")

# Define decision variables
x_c = model.addVar(name="cream_lipsticks", vtype=GRB.CONTINUOUS, lb=0)
x_m = model.addVar(name="matte_lipsticks", vtype=GRB.CONTINUOUS, lb=0)

# Objective function: Maximize total profit
model.setObjective(70*x_c + 100*x_m, GRB.MAXIMIZE)

# Constraints
model.addConstr(3.5*x_c + 5*x_m <= 300, name="raw_materials")
model.addConstr(5*x_c + 3*x_m <= 400, name="mixing")
model.addConstr(2*x_c + 1.5*x_m <= 200, name="packing")

# Optimize the model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cream Lipsticks: {x_c.x}")
    print(f"Matte Lipsticks: {x_m.x}")
    print(f"Total Profit: ${70*x_c.x + 100*x_m.x:.2f}")
else:
    print("No optimal solution found")
