
import gurobi

def solve_lipstick_production():
    # Create a new model
    model = gurobi.Model()

    # Decision variables
    C = model.addVar(lb=0, name="Cream_Lipsticks")
    M = model.addVar(lb=0, name="Matte_Lipsticks")

    # Objective function
    model.setObjective(70*C + 100*M, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3.5*C + 5*M <= 300, name="Raw_Materials")
    model.addConstr(5*C + 3*M <= 400, name="Mixing")
    model.addConstr(2*C + 1.5*M <= 200, name="Packing")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production levels: Cream Lipsticks = {C.varValue}, Matte Lipsticks = {M.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_lipstick_production()
