
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Cosmetics_Advertising")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="social_media_ads")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="tv_ads")


# Set objective function
m.setObjective(30000 * x + 50000 * y, GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * x + 3 * y >= 20, "young_girls_constraint")
m.addConstr(x + 7 * y >= 30, "middle_aged_women_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal}")
    print(f"Number of Social Media Ads: {x.x}")
    print(f"Number of TV Ads: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

