
from gurobipy import *

# Create a model
m = Model("Advertising")

# Define decision variables
x_s = m.addVar(vtype=GRB.CONTINUOUS, name="social_media_commercials")
x_t = m.addVar(vtype=GRB.CONTINUOUS, name="television_commercials")

# Objective function: Minimize total cost
m.setObjective(30000*x_s + 50000*x_t, GRB.MINIMIZE)

# Constraints
m.addConstr(5000000*x_s + 3000000*x_t >= 20000000, "young_girls_constraint")
m.addConstr(1000000*x_s + 7000000*x_t >= 30000000, "middle_aged_women_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Social Media Commercials: {x_s.x}")
    print(f"Television Commercials: {x_t.x}")
    print(f"Total Cost: ${30000*x_s.x + 50000*x_t.x:.2f}")
else:
    print("No optimal solution found.")
